<?php
session_start();
require_once '../config/db.php';

// SEGURIDAD PRO: Solo el Admin puede borrar
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    header("Location: dashboard.php?error=access_denied");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['id'])) {
    $id = $_POST['id'];

    // No permitir que el admin se borre a sí mismo
    if ($id == $_SESSION['user_id']) {
        header("Location: usuarios.php?error=self_delete");
        exit;
    }

    $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
    $stmt->execute([$id]);
}

header("Location: usuarios.php?status=deleted");
exit;